/*
 * Copyright (c) 2008 - 2012, Andy Bierman, All Rights Reserved.
 * Copyright (c) 2012 - 2020, YumaWorks, Inc., All Rights Reserved.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *

*** Generated by yangdump-sdk lion-integ-2020-05-15.10.02-THD

    Combined SIL module
    module enum-test
    revision 2020-05-15
    namespace http://netconfcentral.org/ns/enum-test
    CLI parameters:
        format c
        indent 4
        log-level debug3
        module enum-test
        output enum-test.c
        sil-edit2
        sil-get2
        unified true

 */

#include <xmlstring.h>

#include "procdefs.h"
#include "agt.h"
#include "agt_action.h"
#include "agt_cb.h"
#include "agt_cfg.h"
#include "agt_rpc.h"
#include "agt_sil_lib.h"
#include "agt_timer.h"
#include "agt_util.h"
#include "agt_val.h"
#include "cfg.h"
#include "dlq.h"
#include "getcb.h"
#include "ncx.h"
#include "ncx_feature.h"
#include "ncxmod.h"
#include "ncxtypes.h"
#include "obj.h"
#include "rpc.h"
#include "status.h"
#include "val.h"
#include "val_child.h"
#include "val_util.h"
#include "xml_val.h"
#include "enum-test.h"

/* module static variables */
static ncx_module_t *enum_test_mod;
static obj_template_t *conf_cont_obj;
static obj_template_t *state_conf_obj;
static val_value_t *conf_cont_val;

/* put your static variables here */

/********************************************************************
* FUNCTION y_enum_test_init_static_vars
*
* initialize module static variables
*
********************************************************************/
static void y_enum_test_init_static_vars (void)
{
    enum_test_mod = NULL;
    conf_cont_obj = NULL;
    state_conf_obj = NULL;
    conf_cont_val = NULL;

    /* init your static variables here */

} /* y_enum_test_init_static_vars */


/********************************************************************
* FUNCTION enum_test_conf_cont_edit
*
* Edit database object callback
* Path: container /conf-cont
* Add object instrumentation in COMMIT phase.
*
* INPUTS:
*     see agt/agt_cb.h for details
*
* RETURNS:
*     error status
********************************************************************/
static status_t
    enum_test_conf_cont_edit (ses_cb_t *scb,
                              rpc_msg_t *msg,
                              agt_cbtyp_t cbtyp,
                              op_editop_t editop,
                              val_value_t *newval,
                              val_value_t *curval)
{
    status_t res = NO_ERR;
    val_value_t *errorval = (curval) ? curval : newval;
    uint32 cur_errs = agt_get_error_count(msg);

    if (LOGDEBUG) {
        log_debug("\nEnter enum_test_conf_cont_edit callback for %s phase",
            agt_cbtype_name(cbtyp));
    }

    if (editop == OP_EDITOP_MERGE) {
        /* the edit is not really on this node; need to get
         * each child_undo record to get the real edited nodes */
        agt_cfg_transaction_t *txcb = RPC_MSG_TXCB(msg);
        agt_cfg_undo_rec_t *child_edit =
            agt_cfg_first_child_edit(txcb, newval, curval);

        while (child_edit) {
            op_editop_t child_editop = OP_EDITOP_NONE;
            val_value_t *child_newval = NULL;
            val_value_t *child_curval = NULL;

            agt_cfg_child_edit_fields(child_edit,
                &child_editop,
                &child_newval,
                &child_curval);

            if (LOGDEBUG2) {
                log_debug2("\nchild edit %s", op_editop_name(child_editop));
                if (child_newval) {
                    log_debug2_append("\nnew");
                    val_dump_value(child_newval, 0, DBG2);
                }
                if (child_curval) {
                    log_debug2_append("\ncur");
                    val_dump_value(child_curval, 0, DBG2);
                }
            }

            obj_template_t *chobj = (child_newval) ?
                VAL_OBJ(child_newval) : VAL_OBJ(child_curval);
            const xmlChar *name = obj_get_name(chobj);

            /**** process child edits here ****/

            if (!xml_strcmp(name, y_enum_test_N_index)) {
                /* leaf index (enumeration) */

            }

            child_edit = agt_cfg_next_child_edit(child_edit);
        }
    }

    switch (cbtyp) {
    case AGT_CB_VALIDATE:
        /* description-stmt validation here */
        break;
    case AGT_CB_APPLY:
        /* database manipulation done here */
        break;
    case AGT_CB_COMMIT:
        /* device instrumentation done here */
        switch (editop) {
        case OP_EDITOP_LOAD:
            break;
        case OP_EDITOP_MERGE:
            break;
        case OP_EDITOP_REPLACE:
            break;
        case OP_EDITOP_CREATE:
            {
                val_value_t *child_enum =
                    val_find_child(newval,
                                   y_enum_test_M_enum_test,
                                   (const xmlChar *)"index");
                if (child_enum) {
                    const xmlChar *valname = VAL_NAME(child_enum);
                    int32 value = VAL_ENUM(child_enum);
                    const xmlChar *name = VAL_ENUM_NAME(child_enum);

                    log_debug2("\n\nVAL name:%s; ENUM value:%u; ENUM name:%s",
                               valname,
                               value,
                               name);
                }

                /**** process other child edits here if needed ****/

            }
            break;
        case OP_EDITOP_DELETE:
            break;
        default:
            res = SET_ERROR(ERR_INTERNAL_VAL);
        }

        if (res == NO_ERR) {
            res = agt_check_cache(&conf_cont_val, newval, curval, editop);
        }

        break;
    case AGT_CB_ROLLBACK:
        /* undo device instrumentation here */
        break;
    default:
        res = SET_ERROR(ERR_INTERNAL_VAL);
    }

    if ((res != NO_ERR) && (cur_errs == agt_get_error_count(msg))) {
        agt_record_error(scb,
                         &msg->mhdr,
                         NCX_LAYER_CONTENT,
                         res,
                         NULL,
                         (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
                         errorval,
                         (errorval) ? NCX_NT_VAL : NCX_NT_NONE,
                         errorval);
    }
    return res;

} /* enum_test_conf_cont_edit */


/********************************************************************
* FUNCTION enum_test_state_conf_get
*
* Get database object callback for container state-conf
* Path: container /state-conf
* Fill in 'get2cb' response fields
*
* INPUTS:
*     see ncx/getcb.h for details (getcb_fn2_t)
*
* RETURNS:
*     error status
********************************************************************/
static status_t
    enum_test_state_conf_get (ses_cb_t *scb,
                              xml_msg_hdr_t *msg,
                              getcb_get2_t *get2cb)
{
    (void)scb;
    (void)msg;

    /* check the callback mode type */
    getcb_mode_t cbmode = GETCB_GET2_CBMODE(get2cb);
    switch (cbmode) {
    case GETCB_GET_VALUE:
        break;
    case GETCB_GETNEXT_VALUE:
        return ERR_NCX_NO_INSTANCE;
    default:
        return SET_ERROR(ERR_INTERNAL_VAL);
    }

    /* an NP container always exists so no test for node_exists
     * by the SIL or SIL-SA callback is needed */
    obj_template_t *obj = GETCB_GET2_OBJ(get2cb);
    status_t res = NO_ERR;

    /* go through all the requested terminal child objects */
    obj_template_t *childobj =
        getcb_first_requested_child(get2cb, obj);
    for (; childobj; childobj =
        getcb_next_requested_child(get2cb, childobj)) {

        const xmlChar *name = obj_get_name(childobj);
        val_value_t *retval = NULL;

        /* Retrieve the value of this terminal node and
         * add with getcb_add_return_val */

        if (!xml_strcmp(name, y_enum_test_N_index)) {
            /* leaf index (enumeration) */
            retval =
                val_make_simval_obj(childobj,
                                    (const xmlChar *)"lm5",
                                    &res);
            if (retval) {
                getcb_add_return_val(get2cb, retval);
            } else {
                return res;
            }
        }
    }

    return res;

} /* enum_test_state_conf_get */


/********************************************************************
* FUNCTION y_enum_test_init
*
* initialize the enum-test server instrumentation library
*
* INPUTS:
*    modname == requested module name
*    revision == requested version (NULL for any)
*
* RETURNS:
*     error status
********************************************************************/
status_t y_enum_test_init (const xmlChar *modname,
                           const xmlChar *revision)
{
    status_t res = NO_ERR;

    y_enum_test_init_static_vars();

    /* change if custom handling done */
    if (xml_strcmp(modname, y_enum_test_M_enum_test)) {
        return ERR_NCX_UNKNOWN_MODULE;
    }

    if (revision && xml_strcmp(revision, y_enum_test_R_enum_test)) {
        return ERR_NCX_WRONG_VERSION;
    }


    res =
        ncxmod_load_module(y_enum_test_M_enum_test,
                           y_enum_test_R_enum_test,
                           agt_get_savedevQ(),
                           &enum_test_mod);
    if (res != NO_ERR) {
        return res;
    }

    conf_cont_obj =
        ncx_find_object(enum_test_mod,
                        y_enum_test_N_conf_cont);
    if (conf_cont_obj == NULL) {
        return ERR_NCX_DEF_NOT_FOUND;
    }

    state_conf_obj =
        ncx_find_object(enum_test_mod,
                        y_enum_test_N_state_conf);
    if (state_conf_obj == NULL) {
        return ERR_NCX_DEF_NOT_FOUND;
    }

    res =
        agt_cb_register_edit2_callback(y_enum_test_M_enum_test,
                                       (const xmlChar *)"/et:conf-cont",
                                       y_enum_test_R_enum_test,
                                       enum_test_conf_cont_edit);
    if (res != NO_ERR) {
        return res;
    }

    res =
        agt_cb_register_get_callback(y_enum_test_M_enum_test,
                                     (const xmlChar *)"/et:state-conf",
                                     y_enum_test_R_enum_test,
                                     enum_test_state_conf_get);
    if (res != NO_ERR) {
        return res;
    }

    /* put your module initialization code here */

    return res;

} /* y_enum_test_init */


/********************************************************************
* FUNCTION y_enum_test_init2
*
* SIL init phase 2: non-config data structures
* Called after running config is loaded
*
* RETURNS:
*     error status
********************************************************************/
status_t y_enum_test_init2 (void)
{
    status_t res = NO_ERR;

    conf_cont_val =
        agt_init_cache(y_enum_test_M_enum_test,
                       y_enum_test_N_conf_cont,
                       &res);
    if (res != NO_ERR) {
        return res;
    }

    /* put your init2 code here */

    return res;

} /* y_enum_test_init2 */

/********************************************************************
* FUNCTION y_enum_test_cleanup
*    cleanup the server instrumentation library
*
********************************************************************/
void y_enum_test_cleanup (void)
{

    agt_cb_unregister_callbacks(y_enum_test_M_enum_test,
                                (const xmlChar *)"/et:conf-cont");

    agt_cb_unregister_callbacks(y_enum_test_M_enum_test,
                                (const xmlChar *)"/et:state-conf");

    /* put your cleanup code here */

} /* y_enum_test_cleanup */

/* END SIL enum_test.c */
